///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ViewScheduleDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HMENU DialogMenu = NULL;

    static BOOL Refresh     = TRUE;

	if(xMessage == WM_INITDIALOG) // Received an initilize dialog message
	{
		ViewScheduleDialog_hWnd = xHandle;

		SendMessage(ViewScheduleDialog_hWnd,(UINT)WM_SETTEXT,(WPARAM)0,(LPARAM)"Schedule Viewer");
		SendMessage(ViewScheduleDialog_hWnd,WM_SETICON,TRUE,(LPARAM)LoadIcon(MainInstance,MAKEINTRESOURCE(100)));

        DialogMenu = LoadMenu(MainInstance, MAKEINTRESOURCE(101));
        SetMenu(ViewScheduleDialog_hWnd, DialogMenu);

		SD.ListView_hWnd = GetDlgItem(ViewScheduleDialog_hWnd, 1000);

        int LVStyle = LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT;
        SendMessage(SD.ListView_hWnd, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)LVStyle);

        SD.LVColumb.cx        = 30;
        SD.LVColumb.pszText   = "ID";
        SD.LVColumb.iSubItem  = 0;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 0, &SD.LVColumb);

        SD.LVColumb.cx        = 100;
        SD.LVColumb.pszText   = "Name";
        SD.LVColumb.iSubItem  = 1;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 1, &SD.LVColumb);

        SD.LVColumb.cx        = 100;
        SD.LVColumb.pszText   = "Description";
        SD.LVColumb.iSubItem  = 2;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 2, &SD.LVColumb);

        SD.LVColumb.cx        = 100;
        SD.LVColumb.pszText   = "Next Operation";
        SD.LVColumb.iSubItem  = 3;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 3, &SD.LVColumb);

        SD.LVColumb.cx        = 100;
        SD.LVColumb.pszText   = "Database";
        SD.LVColumb.iSubItem  = 4;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 4, &SD.LVColumb);

        SD.LVColumb.cx        = 200;
        SD.LVColumb.pszText   = "Filename";
        SD.LVColumb.iSubItem  = 5;
        SD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        SD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(SD.ListView_hWnd, 5, &SD.LVColumb);

        LoadScheduleIntoDialog();

        SetTimer(ViewScheduleDialog_hWnd, 0, 10000, NULL);

		CenterWindow(ViewScheduleDialog_hWnd);

		return 0;
	}

    //--------------------------------------------------------------------------

    if(xMessage == WM_SIZE ) // Received A Message
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);
        MoveWindow(SD.ListView_hWnd, 0, 0, nWidth, nHeight, TRUE);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_TIMER)
    {
        if(Refresh == FALSE)
            return 0;

        ListView_DeleteAllItems(SD.ListView_hWnd);
        LoadScheduleIntoDialog();
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_COMMAND) // Received a message
	{
        if(wParam==10001) //- Close (Dialog Menu Command)
        {
            EndDialog(ViewScheduleDialog_hWnd, 0);
            DestroyWindow(ViewScheduleDialog_hWnd);
            return 0;
        }

        if(wParam==20001) //- Refresh now (Dialog Menu Command)
        {
            ListView_DeleteAllItems(SD.ListView_hWnd);
            LoadScheduleIntoDialog();
            return 0;
        }
        if(wParam==20002) //- Refresh on / off toggle (Dialog Menu Command)
        {
            if(Refresh == TRUE)
            {
                ModifyMenu(DialogMenu, 20002, MF_BYCOMMAND+MF_UNCHECKED, 20002, "Refresh off");
                Refresh = FALSE;
                return 0;
            }

            if(Refresh == FALSE)
            {
                ModifyMenu(DialogMenu, 20002, MF_BYCOMMAND+MF_CHECKED, 20002, "Refresh on");
                Refresh = TRUE;
                return 0;
            }
            return 0;
        }

		return 0;
	}

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(ViewScheduleDialog_hWnd, 0);
		EndDialog(ViewScheduleDialog_hWnd, 0);
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

